

AntiJoin()
{
    level.AntiJoin = (isDefined(level.AntiJoin) ? undefined : true);
    
    if(!isDefined(level.AntiJoin))
    {
        self iPrintln("Anti Join: ^1Off");
        SetDvar("g_password","");
    }
    else
    {
        self iPrintln("Anti Join ^2On");
        SetDvar("g_password","@CF4");
    }
}

AntiQuit()
{
    level.AntiQuit = (isDefined(level.AntiQuit) ? undefined : true);
    
    if(!isDefined(level.AntiQuit))
        self iPrintln("Anti Quit: ^1Off");
    else
    {
        self iPrintln("Anti Quit: ^2On");
        
        while(isDefined(level.AntiQuit))
        {
            foreach(player in level.players)
                player closeInGameMenu();
            wait .05;
        }
    }
}

ServerSetLobbyTimer(input)
{
    timeLeft       = GetDvar("scr_"+level.gametype+"_timelimit");
    timeLeftProper = int(timeLeft);
    if(input == "add")
        setTime = timeLeftProper + 1;
    if(input == "sub")
        setTime = timeLeftProper - 1;
    SetDvar("scr_"+level.gametype+"_timelimit",setTime);
    time = setTime - getMinutesPassed();
    wait .05;
    
    if(input == "add")
        self iPrintln("^2Added 1 minute");
    else
        self iPrintln("^1Removed 1 minute");
}

InfiniteGame()
{
    level.InfiniteGame = (isDefined(level.InfiniteGame) ? undefined : true);
    
    if(!isDefined(level.InfiniteGame))
    {
        level thread maps\mp\gametypes\_gamelogic::resumeTimer();
        SetDvar("scr_"+level.gametype+"_scorelimit",level.SavedScoreLimit);
        self iPrintln("Infinite Game: ^1Off");
    }
    else
    {
        level.SavedScoreLimit = GetDvar("scr_"+level.gametype+"_scorelimit");
        
        level thread maps\mp\gametypes\_gamelogic::pauseTimer();
        SetDvar("scr_"+level.gametype+"_scorelimit",0);
        self iPrintln("Infinite Game: ^2On");
    }
}


MaxTeamCount()
{
    level.teamLimit = 18;
    SetDvar("sv_maxclients",18);
    SetDvar("scr_teambalance",0);
    self iPrintln("Teams can now have 18 players");
}




DoHeart()
{
    if(!isDefined(level.DoHeart))
    {
        level.DoHeart = true;
        level thread DoHeartTextPass();
        self iPrintln("Do Heart: ^2On");
    }
    else
    {
        level.DoHeart = undefined;
        if(isDefined(level.DoHeartHUD))
            level.DoHeartHUD destroy();
        self iPrintln("Do Heart: ^1Off");
    }
}

DoHeartTextPass(custom)
{
    if(!isDefined(custom))
        self thread SetDoHeartText(level.DoHeartText);
    else
        self Keyboard("DoHeart Text",::SetDoHeartText);
}

SetDoHeartText(text)
{
    level.DoHeartText = text;
    self iPrintln("DoHeart Text: ^2"+text);
    if(!isDefined(level.DoHeart) || !isDefined(text))
        return;
    
    if(isDefined(level.DoHeartHUD))
        level.DoHeartHUD SetSafeText(level.DoHeartText);
    else
    {
        level.DoHeartHUD           = createServerText("default",1.1,"CENTER","CENTER",-275,-85,1,1,level.DoHeartText,(1,1,1));
        level.DoHeartHUD.glowAlpha = 1;
        level.DoHeartHUD.glowColor = (1,0,0);
        level.DoHeartHUD thread TextPulse();
    }
}

TextPulse()
{
    while(isDefined(self))
    {
        self ChangeFontScaleOverTime1(self.FontScale+1.2,.55);
        wait .5;
        self ChangeFontScaleOverTime1(self.FontScale-1.2,.55);
        wait .5;
    }
}


ServerRestart()
{
    map_restart(false);
}